; //------------------ fixedXYZCT2fogA ----------------------------

; //--------------------- Constants -------------------------------

; genral definitions
#define ZERO c5.x
#define ONE c5.y
#define PI c5.z
#define EPSILON c5.w
#define R_MODEL_VERT r0
#define R_MODEL_NORMAL r1

; fog definitions
#define R_VERT_TO_FOG r5
#define R_VERT_TO_INTERSECT r6
#define R_VERT_DISTANCE r7
#define R_INTERSECT_DISTANCE r8
#define IS_ZERO	r9
#define IS_NEG r10
#define R_FOG r11

; lighting definitions
#define R_TEMP r6
#define R_VERT_TO_LIGHT r7
#define R_ATTENUATION r8
#define R_INTENSITY r9
#define R_DIFFUSE r10
#define R_SPECULAR r11

; //--------------------- Version -------------------------------

; vertex shader version 1.1
xvs.1.1

; //--------------- Apply Vertex Weights ------------------------

; move position
mov R_MODEL_VERT, v0

; move normal
mov R_MODEL_NORMAL, v1

; //------------------- Xform Vertices -----------------------------

;transform vertices by view/projection matrix
m4x4 oPos, R_MODEL_VERT, c0

; //----------------- Calculate Texture UV -------------------------

;copy texture coordinates to output   
mov oT0.xy, v3
mov oT1.xy, v4

; //--------------------- Calculate Fog ----------------------------

;calculate vertex-to-fog vector
add R_VERT_TO_FOG, c4, -R_MODEL_VERT	
dp3 R_VERT_DISTANCE.w, R_VERT_TO_FOG, R_VERT_TO_FOG
rsq R_VERT_TO_FOG.w, R_VERT_DISTANCE.w

; calculate vertex-to-fog distance
dst R_VERT_DISTANCE, R_VERT_DISTANCE.wwww, R_VERT_TO_FOG.wwww

; calculate range based fog
mad oFog.x, R_VERT_DISTANCE.y, c10.x, c10.y

; //------------------- Calculate Lighting -------------------------

; //--------------------- Ambient Light ----------------------------

; accumulate ambient light
mov R_DIFFUSE, c20

; //----------------------- Clamp Color --------------------------

max R_DIFFUSE, R_DIFFUSE, c5.x
min R_DIFFUSE, R_DIFFUSE, c5.y
mov oD0, R_DIFFUSE

